# Given an input vods_owner_id.txt file, populate the deprecated_vod_owner_used_for_rechat table. vods_owner_id.txt should be formatted like:
# vod_id1 owner_id1
# vod_id2 owner_id2
# vod_id3 owner_id3
#

import json
import psycopg2
import requests
import time

#DB connection string
#Define our connection string
conn_string = "host='vinyl-production-master.ciea1tubqwoo.us-west-2.rds.amazonaws.com' dbname='vinyl' user='vinyl'"
print "Connecting to database\n ->%s" % (conn_string)

# get a connection, if a connect cannot be made an exception will be raised here
conn = psycopg2.connect(conn_string)

# conn.cursor will return a cursor object, you can use this cursor to perform queries
cursor = conn.cursor()
print "Connected!\n"

# This is the deprcated table that will be populated
table_name = "deprecated_vod_owner_used_for_rechat"

f = open('vods_owner_id.txt', 'r')

users_service_url = "http://users-service.prod.us-west2.twitch.tv/users/"

#Local cache to save the id -> name lookup.
owners_cache = dict()

#Sleep for this many seconds before processing the next vod.
sleep_time = 0.05

for line in f:
    time.sleep(sleep_time)
    line = line.strip()

    (vod_id, owner_id) = line.split(" ")

    owner_login = owners_cache.get(owner_id)
    if not owner_login:
        owner_login = requests.get(users_service_url + owner_id).json()['login']

    if owner_login is None:
        print vod_id, " ERRORCHECK: ==>", " Unable to find login for user with id: {}" % owner_id
    else:
        try:
            cursor.execute("INSERT INTO {} VALUES(%s, %s)".format(table_name), (vod_id, owner_login))
            conn.commit()
            print "Inserted %s: %s" % (vod_id, owner_login)
            owners_cache[owner_id] = owner_login
        except psycopg2.Error as e:
            print vod_id, " ERRORCHECK: ==>", e.pgerror
            pass
cursor.close()
