#!/usr/bin/env
import psycopg2
import argparse

def main(args):
  # for production
  # conn_string = "host='vinyl-production-master.ciea1tubqwoo.us-west-2.rds.amazonaws.com' dbname='vinyl' user='vinyl' password=''"
  # for local testing
  conn_string = "host='localhost' dbname='vinyl' user='jiajame' password=''"
  # for staging
  # conn_string = "host='vinyl-staging-master.cifgffw7w2ar.us-west-2.rds.amazonaws.com' dbname='vinyl' user='vinyl' password=''"
  print "Connecting to database\n ->%s" % (conn_string)
 
  # get a connection, if a connect cannot be made an exception will be raised here
  conn = psycopg2.connect(conn_string)
 
  # conn.cursor will return a cursor object, you can use this cursor to perform queries
  cursor = conn.cursor()
  print "Connected!\n"

  with open(args.file, "r") as vod_appeals:
    prev_vod_appeal_id, prev_track_appeal_id = None, None
    for line in vod_appeals:
      arr = line.strip().split(",")
      track_appeal_id = arr[0]
      vod_appeal_id = arr[1]

      if prev_vod_appeal_id and prev_vod_appeal_id != vod_appeal_id:
        cursor.execute("select COUNT(*) from track_appeals where vod_appeal_id = {}".format(prev_vod_appeal_id))
        print "select COUNT(*) from track_appeals where vod_appeal_id = {}".format(prev_vod_appeal_id)
        appeals_left = cursor.fetchone()
        if appeals_left is None:
          print "Wasn't able to count the number of track appeals left for vod appeal {}".format(prev_vod_appeal_id)
        if appeals_left[0] == 0:
          executeQuery(conn, cursor, "DELETE FROM vod_appeals where id = {}".format(prev_vod_appeal_id))

      executeQuery(conn, cursor, "DELETE FROM track_appeals where id = {}".format(track_appeal_id))

      prev_vod_appeal_id, prev_track_appeal_id = vod_appeal_id, track_appeal_id


  cursor.close()

def executeQuery(conn, cursor, query):
  try:
    cursor.execute(query)
    print query
    conn.commit()
  except psycopg2.Error as e:
    print "Query failed"
    print e

if __name__ == "__main__":
  parser = argparse.ArgumentParser()
  parser.add_argument("file", help="file containing rows to delete from the db")
  args = parser.parse_args()
  main(args)

