# Vinyl Development

### Table of Contents

* **[Getting Setup](#getting-setup)**
* **[Running Vinyl](#running-vinyl)**
* **[Tests](#tests)**
* **[Migrations](#migrations)**


### Getting Setup
Vinyl's infrastructure currently lives in `twitch-web-aws` for production, and `twitch-web-dev` for staging
environments. You will need to ask for access to these accounts in order to get sandstorm secrets and make
any changes. Try asking in the Slack #web channel for someone to give you these permissions.

Once you have access to the AWS accounts, you will need to attach the sandstorm policy to get database
credentials and other secrets.

Attach the `sandstorm-search-discovery-local` IAM policy to your AWS user in the `twitch-web-dev` account.

With the IAM policy, you can run sandstorm in your Vinyl root directory to generate a `config` file with
staging secrets:

```
make sandstorm
```

You're now ready to run a Vinyl server locally.


### Running Vinyl
Once you have Vinyl setup you're ready to run the server. Getting your
code running is different for each environment.

##### Locally
To run vinyl locally, you can simply build and run the program:
```
go run main.go
```

##### Development Server
When you want to test your code on a beanstalk environment with the freedom
to cause problems without interrupting the deployment process, you can setup
a development environment using the following steps:


### Tests
Any new code added to Vinyl should have test coverage.

##### Unit Tests

Install [goconvey](https://github.com/smartystreets/goconvey)

```
go get github.com/smartystreets/goconvey
```

Install [mockery](https://github.com/vektra/mockery)

```
go get github.com/vektra/mockery/.../
```

If you make a modification to an interface, regenerate the mock for that interface (in the same directory as the interface)

```
cd api
mockery -name=Backend
```

Run tests in the browser (localhost:8080) and view coverage

```
goconvey
```

##### Integration Tests

We have integration tests set up using our own vinyl-ruby client. These run on every single build just like regular tests. To run them locally, install Vagrant and Docker:

```
brew cask install virtualbox
brew cask install vagrant
brew cask install docker-toolbox
```

After that, start the Vagrant machine and ssh into it:
```
vagrant up
vagrant ssh
```

And navigate to the Vinyl folder to run Manta:
```
cd /go/src/code.justin.tv/vod/vinyl
manta -f build.json
```

This will simulate our entire build process, including integration tests.

### Migrations

**All migrations must follow this process, people are not allowed to run migrations by hand.**
* Create a [goose](https://bitbucket.org/liamstask/goose/) migration file
* Test the migration by running it on the staging database
* Submit a PR with the migration code
* Once reviewed, merge the PR into master
* Run the PR against the production database
