# Vinyl Operations

This document outlines how Vinyl infrastructure is setup. We use Cloudformation to define Vinyl's resources in AWS.
Vinyl is run with Elastic Beanstalk, using Codepipeline for deployments and Jenkins to run tests and create build
artifacts.

### Table of Contents

* **[AWS Account](#aws-account)**
* **[Cloudformation](#cloudformation)**
* **[Beanstalk](#beanstalk)**

### AWS Account
Vinyl runs within its own AWS account `twitch-vinyl-aws`. [Isengard](https://isengard.amazon.com/) is used to manage access
and administration. You will need to be on Amazon's network to access Isengard.

### Cloudformation

Cloudformation is used to define AWS resources needed by Vinyl within our codebase. Configuration can be
found in the [cloudformation](/configuration/cloudformation) directory.

[global](/configuration/cloudformation/global.yaml) defines account-wide resources used by many other
cloudformation stacks, such as S3 buckets and service Roles.

Each environment has its own stack, such as [staging](/configuration/cloudformation/staging.yaml). These
stacks define resources and configuration specific to the environment. For instance, staging has two
instances in its scaling group, while production has 15-25 instances.


##### Updating Cloudformation

To Update Vinyl's Cloudformation configuration, make changes to the respective cloudformation template,
such as [staging.yaml](/configuration/cloudformation/staging.yaml), then use the aws command-line
tool to create and execute a change set:

```
aws s3 cp staging.yaml s3://cloudformation-templates.vinyl.twitch.tv/vinyl/staging.yaml
aws cloudformation create-change-set --stack-name staging --template-url https://s3-us-west-2.amazonaws.com/cloudformation-templates.vinyl.twitch.tv/vinyl/staging.yaml --change-set-name <name>
aws cloudformation execute-change-set --change-set-name <name>
```

### Sandstorm

Vinyl uses [Sandstorm](https://git-aws.internal.justin.tv/systems/sandstorm) to store secrets. In order for Vinyl to access Sandstorm, Vinyl needs to create an IAM role giving access to Sandstorm resources.
A VinylInstanceProfile AMI role has been defined and linked to Vinyl's Sandstorm secrets through [Sandstorm Dashboard](https://dashboard.internal.justin.tv/sandstorm/manage-roles). You can attach this role to instances for Sandstorm access.

### HAProxy

Vinyl uses an HAProxy server to load balance requests to database read slaves. The [configuration](/configuration/docker/haproxy.cfg) is copied into each instance and servers are run alongside the vinyl app.

### Lambda Functions

Vinyl uses Lambda functions for various background tasks, such as publishing scheduled vods. Lambda functions
can be found in the [lambda](/configuration/lambda) directory.

The lambda directory contains the [base cloudformation template](/configuration/lambda/cloudformation.yaml),
 which gets the individual lambda functions' templates concatenated to it during deploy. The functions are
 defined in the [functions](/configuration/lambda/functions) directory. Each function has a subdirectory
 containing its cloudformation definition and code.

Use the [deploy](/configuration/lambda/deploy.sh) to deploy new lambda functions. This script will
concatenate the cloudformation templates together and update the cloudformation stack, it will also
zip and upload to S3 each lambda function. Vinyl's lambda functions rarely change, so this script
will not re-deploy existing functions. To update a function, run the deploy script, then use the
Lambda AWS console to bump the function's version. 
