import javaposse.jobdsl.dsl.helpers.step.*

StepContext.metaClass.zipMantaBeanstalkBundle = { String zipfile ->
  shell """
echo hello
rm -rf .manta
manta -v -f manta.json
cd .manta
zip -r ../${zipfile} .
"""
}

StepContext.metaClass.s3Copy = { String source, String path ->
shell """
export AWS_ACCESS_KEY_ID=\$AWS_ACCESS_KEY
export AWS_SECRET_ACCESS_KEY=\$AWS_SECRET_KEY
export AWS_DEFAULT_REGION=us-west-2
aws s3 cp ${source} s3://vinyl-elasticbeanstalk-build-artifacts/apps/vinyl/${path}
"""
}

StepContext.metaClass.uploadBeanstalkBundle = { String filename, String version ->
  s3Copy "${filename}", "${version}.zip"
}


StepContext.metaClass.uploadMantaBeanstalkBundle = { ->
  zipFile = "application.zip"
  version = "\${GIT_COMMIT}"
  zipMantaBeanstalkBundle zipFile
  uploadBeanstalkBundle zipFile, version
}

StepContext.metaClass.deployElasticBeanstalkArtifact = { String version, String env ->
  s3Copy "s3://vinyl-elasticbeanstalk-build-artifacts/apps/vinyl/${version}.zip", "${env}.zip"
}

freeStyleJob('vod-vinyl-test') {
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'vod/vinyl', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
      credentialsBinding {
          string 'AWS_ACCESS_KEY', 'vinyl-aws-access-key'
          string 'AWS_SECRET_KEY', 'vinyl-aws-secret-key'
      }
  }

  steps {
    shell 'manta -update -v -f manta.json'
    saveDeployArtifact 'vod/vinyl', '.manta'
    uploadMantaBeanstalkBundle()
  }
}

freeStyleJob('vod-vinyl-deploy-test') {
  using 'TEMPLATE-deploy-aws'

  wrappers {
      credentialsBinding {
          string 'AWS_ACCESS_KEY', 'vinyl-aws-access-key'
          string 'AWS_SECRET_KEY', 'vinyl-aws-secret-key'
      }
  }

  steps {
    shell 'courier deploy --repo vod/vinyl --dir /opt/twitch/vinyl'
    deployElasticBeanstalkArtifact "\${GIT_COMMIT}", "\$ENVIRONMENT"
  }
}
