package models

import "time"

// TrackAppeal is the external facing Vinyl representation of a track appeal.
type TrackAppeal struct {
	TrackAppealID          int64     `json:"id"`
	AudibleMagicResponseID int64     `json:"audible_magic_response_id"`
	VodAppealID            int64     `json:"vod_appeal_id"`
	Reason                 string    `json:"reason"`
	CreatedAt              time.Time `json:"created_at"`
	UpdatedAt              time.Time `json:"updated_at"`
	ResolvedAt             NullTime  `json:"resolved_at"`
}

// TrackAppealList is a list of TrackAppeal objects.
type TrackAppealList []*TrackAppeal
