package models

import "time"

// UserVideoPrivacyPropertiesFields is fields that can be updated through the API
var UserVideoPrivacyPropertiesFields = []string{"hide_archives"}

// UserVideoPrivacyProperties is the external user facing representation of user video privacy properties.
type UserVideoPrivacyProperties struct {
	UserID       int64     `json:"user_id"`
	HideArchives bool      `json:"hide_archives"`
	CreatedAt    time.Time `json:"created_at"`
	UpdatedAt    time.Time `json:"updated_at"`
}

// UserVideoPrivacyPropertiesInput is the user input when updating user video privacy properties
type UserVideoPrivacyPropertiesInput struct {
	HideArchives NullBool  `json:"hide_archives"`
	CreatedAt    time.Time `json:"created_at"`
	UpdatedAt    time.Time `json:"updated_at"`
}

// ValuesList is the list of values to be passed into sql when updating user video privacy properties
func (U *UserVideoPrivacyPropertiesInput) ValuesList() []interface{} {
	return []interface{}{
		U.HideArchives,
		U.CreatedAt,
		U.UpdatedAt,
	}
}
