package models

import "time"

// UserVODPropertiesFields is fields that can be updated through the API
var UserVODPropertiesFields = []string{
	"save_vods_forever",
	"vod_storage_days",
	"can_upload_vod",
	"youtube_exporting_disabled",
	"skip_upload_moderation",
}

// UserVODProperties is the external representation of the properties of vods belonging to a specific user.
type UserVODProperties struct {
	UserID                   int64     `json:"user_id"`
	SaveVODsForever          bool      `json:"save_vods_forever"`
	VODStorageDays           int       `json:"vod_storage_days"`
	CanUploadVOD             bool      `json:"can_upload_vod"`
	YoutubeExportingDisabled bool      `json:"youtube_exporting_disabled"`
	SkipUploadModeration     bool      `json:"skip_upload_moderation"`
	CreatedAt                time.Time `json:"created_at"`
	UpdatedAt                time.Time `json:"updated_at"`
}

// UserVODPropertiesInput is the user input when updating UserVodProperties
type UserVODPropertiesInput struct {
	SaveVODsForever          NullBool  `json:"save_vods_forever"`
	VODStorageDays           NullInt64 `json:"vod_storage_days"`
	CanUploadVOD             NullBool  `json:"can_upload_vod"`
	YoutubeExportingDisabled NullBool  `json:"youtube_exporting_disabled"`
	SkipUploadModeration     NullBool  `json:"skip_upload_moderation"`
	CreatedAt                time.Time `json:"created_at"`
	UpdatedAt                time.Time `json:"updated_at"`
}

// ValuesList is the list of values to be passed into SQL when updating User VOD Properties
func (U *UserVODPropertiesInput) ValuesList() []interface{} {
	return []interface{}{
		U.SaveVODsForever,
		U.VODStorageDays,
		U.CanUploadVOD,
		U.YoutubeExportingDisabled,
		U.SkipUploadModeration,
		U.CreatedAt,
		U.UpdatedAt,
	}
}
