package models

import "time"

// VodAppeal is the external user facing representation of a Vod appeal.
type VodAppeal struct {
	VodAppealID    int64     `json:"id"`
	ResolvedAt     NullTime  `json:"resolved_at"`
	CreatedAt      time.Time `json:"created_at"`
	UpdatedAt      time.Time `json:"updated_at"`
	VodID          int64     `json:"vod_id"`
	Priority       bool      `json:"priority"`
	FullName       string    `json:"full_name"`
	StreetAddress1 string    `json:"street_address_1"`
	StreetAddress2 string    `json:"street_address_2"`
	City           string    `json:"city"`
	State          string    `json:"state"`
	Zipcode        string    `json:"zipcode"`
	Country        string    `json:"country"`
}

// VodAppealList is a list of vod appeals.
type VodAppealList []*VodAppeal
