package models

import "time"

// VodNotificationSettings is the external facing representation of notification settings associated with a VOD.
type VodNotificationSettings struct {
	ID         int64      `json:"id"`
	VodID      int64      `json:"vod_id"`
	Type       string     `json:"type"`
	CustomText NullString `json:"custom_text"`
	Enabled    bool       `json:"enabled"`
	SentAt     NullTime   `json:"sent_at"`
	CreatedAt  time.Time  `json:"created_at"`
	UpdatedAt  time.Time  `json:"updated_at"`
}

// VodNotificationSettingsList represents a list of VodNotificationSettings
type VodNotificationSettingsList []*VodNotificationSettings

// VodNotificationSettingsMap represents the map of valid VodNotificationSettings
type VodNotificationSettingsMap struct {
	Email       *VodNotificationSettings `json:"email,omitempty"`
	ChannelFeed *VodNotificationSettings `json:"channel_feed,omitempty"`
}

// AsList returns the settings as VodNotificationSettingsList
func (M *VodNotificationSettingsMap) AsList() VodNotificationSettingsList {
	notificationSettingsList := make(VodNotificationSettingsList, 0, 2)
	if M.Email != nil {
		notificationSettingsList = append(notificationSettingsList, M.Email)
	}
	if M.ChannelFeed != nil {
		notificationSettingsList = append(notificationSettingsList, M.ChannelFeed)
	}
	return notificationSettingsList
}
