package models

import (
	"net/url"
	"testing"

	. "github.com/smartystreets/goconvey/convey"
)

func TestParseFilters(t *testing.T) {
	Convey("Defaults to using no filters", t, func() {
		filters, _ := ParseFilters(url.Values(map[string][]string{}))
		So(filters.IncludeDeleted, ShouldEqual, true)
		So(filters.IncludePrivate, ShouldEqual, true)
		So(filters.IncludeProcessing, ShouldEqual, true)
	})
	Convey("Can parse include_deleted", t, func() {
		filters, _ := ParseFilters(url.Values(map[string][]string{"include_deleted": []string{"false"}}))
		So(filters.IncludeDeleted, ShouldEqual, false)
	})
	Convey("Can parse include_private", t, func() {
		filters, _ := ParseFilters(url.Values(map[string][]string{"include_private": []string{"false"}}))
		So(filters.IncludePrivate, ShouldEqual, false)
	})
	Convey("Can parse include_processing", t, func() {
		filters, _ := ParseFilters(url.Values(map[string][]string{"include_processing": []string{"false"}}))
		So(filters.IncludeProcessing, ShouldEqual, false)
	})
	Convey("Returns an error when a filter is invalid", t, func() {
		_, err := ParseFilters(url.Values(map[string][]string{"include_processing": []string{"fake"}}))
		So(err, ShouldNotEqual, nil)
	})
}
