#!/bin/bash
set -euo pipefail

# The below db credentials aren't "real", we just use them to connect to the local test postgres db created below
echo '{
    "vinyl_db_user_password": "whatever",
    "vinyl_db_user_name": "vinyl"
}' > config

# Install a local postgres db
./scripts/manta_postgres.sh

goose up

ENVIRONMENT=testing ./output/vinyl &

# Install rspec
cd scripts/ruby
bundle install
# Run rspec integration tests against running Vinyl instances
bundle exec rspec spec/
