require 'vinyl'
require 'faraday'

describe ::Vinyl::API::AmrV1 do
  before :all do
    @client = (::Vinyl::Client.new do |config|
      config.endpoint = "http://localhost:8000"
    end).amrs
    @amrs = (0..2).map do |vod_id|
      puts vod_id
      amr_fields = {:vod_id => vod_id, :is_match => true}
      @client.create_amr(:vod_id => vod_id, :amr_fields => [amr_fields])["audible_magic_responses"][0]
    end
  end

  describe '.create_amr' do
    it 'succeeds in calling vinyl' do
      amr_fields = {:vod_id => 123, :is_match => true}
      res = @client.create_amr(vod_id: 123, amr_fields: [amr_fields])
      expect(res).to_not be_nil
      expect(res["audible_magic_responses"]).to_not be_nil
    end
  end

  describe '.get_for_vod' do
    it 'succeeds in calling vinyl' do
      res = @client.get_for_vod(vod_id: 0)
      expect(res).to_not be_nil
      expect(res.length).to eq(1)
      expect(res[0]['vod_id']).to eq(0)
      expect(res[0]['is_match']).to eq(true)
    end
  end

  describe '.update_amr' do
    it 'succeeds in calling vinyl' do
      res = @client.update_amr(amr_id: @amrs[0]["id"], amr_fields: {:is_match => false})
      expect(res).to_not be_nil
      expect(res["audible_magic_response"]["is_match"]).to eq(false)
    end
  end
end
