resource "aws_sns_topic" "pagerduty_alarm" {
  name = "pagerduty_vinyl"
}

module "internal_app_elb_alarms" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/web/terraform.git//modules/elb/alarms"
  elb_name = "${aws_elb.internal_app_elb.name}"
  action_arns = "${aws_sns_topic.pagerduty_alarm.arn}"
}

resource "aws_cloudwatch_metric_alarm" "app-cpu" {
  alarm_name = "${var.name}-${var.environment}-app-cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "50"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "app-status" {
  alarm_name = "${var.name}-${var.environment}-app-status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-cpu" {
  alarm_name = "${var.name}-${var.environment}-canary-app-cpu"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "5"
  metric_name = "CPUUtilization"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "50"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}

resource "aws_cloudwatch_metric_alarm" "canary-app-status" {
  alarm_name = "${var.name}-${var.environment}-canary-app-status"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods = "3"
  metric_name = "StatusCheckFailed"
  namespace = "AWS/EC2"
  period = "60"
  statistic = "Average"
  threshold = "1"
  dimensions = {AutoScalingGroupName = "${aws_autoscaling_group.canary_app_asg.id}"}
  alarm_actions = ["${aws_sns_topic.pagerduty_alarm.arn}"]
}