resource "aws_iam_role" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "app" {
  name = "${var.iam_role_name}"
  role = "${aws_iam_role.app.id}"
  depends_on = ["aws_iam_role.app"]
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Resource": "arn:aws:iam::734326455073:role/sandstorm-agent-search-discovery-vinyl-${var.environment}"
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${var.iam_role_name}-${var.environment}"
  roles = ["${aws_iam_role.app.name}"]
}

resource "aws_iam_policy" "vinyl_app_kinesis" {
  name = "vinyl_app_kinesis"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "kinesis:*",
      "Resource": "*"
    }
  ]
}
EOF
}

resource "aws_iam_policy" "vinyl_app_sns" {
  name = "vinyl_app_sns"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "sns:Publish",
      "Resource": "${aws_sns_topic.vodupload_topic.arn}"
    }
  ]
}
EOF
}

resource "aws_iam_policy" "vinyl_app_list_alias" {
 name = "vinyl_app_list_alias"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "iam:ListAccountAliases",
      "Resource": "*"
    }
  ]
}
EOF
}

resource "aws_iam_policy" "vinyl_app_ses" {
 name = "vinyl_app_ses"
  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": "ses:*",
      "Resource": "*"
    }
  ]
}
EOF
}

resource "aws_iam_policy_attachment" "kinesis" {
  name = "vinyl_app_kinesis"
  roles = ["${aws_iam_role.app.name}"]
  policy_arn = "${aws_iam_policy.vinyl_app_kinesis.arn}"
}

resource "aws_iam_policy_attachment" "iam" {
  name = "vinyl_app_list_alias"
  roles = ["${aws_iam_role.app.name}"]
  policy_arn = "${aws_iam_policy.vinyl_app_list_alias.arn}"
}

resource "aws_iam_policy_attachment" "ses" {
  name = "vinyl_app_ses"
  roles = ["${aws_iam_role.app.name}"]
  policy_arn = "${aws_iam_policy.vinyl_app_ses.arn}"
}

resource "aws_iam_policy_attachment" "sns" {
  name = "vinyl_app_sns"
  roles = ["${aws_iam_role.app.name}"]
  policy_arn = "${aws_iam_policy.vinyl_app_sns.arn}"
}

