package utils

import (
	"fmt"
)

// FullyQualifyAttributeName appends the table name as a prefix to the attributes.
// Does not modify the original array.
func FullyQualifyAttributeName(attributes []string, table string) []string {
	qualifiedAttributes := make([]string, len(attributes))
	for i := range attributes {
		qualifiedAttributes[i] = fmt.Sprintf("%s.%s", table, attributes[i])
	}
	return qualifiedAttributes
}
