package utils

import (
	"bytes"
	"encoding/json"
)

// JSONDecoderWithNumbers returns a decoder which unmarshals numbers into interface{} instead of float64
func JSONDecoderWithNumbers(body []byte) *json.Decoder {
	dec := json.NewDecoder(bytes.NewReader(body))
	dec.UseNumber()
	return dec
}

// NormalizeJSONMap sees whether any of the values are of the type
// json.Number, and changes those to ints or floats appropriately.
// Other values remain unchanged.
func NormalizeJSONMap(in map[string]interface{}) map[string]interface{} {
	out := map[string]interface{}{}
	for k, v := range in {
		switch val := v.(type) {
		case json.Number:
			if i, err := val.Int64(); err == nil {
				out[k] = i
			} else if f, err := val.Float64(); err == nil {
				out[k] = f
			}
		default:
			out[k] = v
		}
	}
	return out

}
