package utils

import (
	"encoding/json"
	"errors"
	"io/ioutil"
	"log"

	"code.justin.tv/common/config"
)

var (
	allSecrets = map[string]string{}

	configFilePath = "config-File-Path"
)

func init() {
	config.Register(map[string]string{
		configFilePath: "config",
	})
}

func fetchSecrets() {
	contents, err := ioutil.ReadFile(config.Resolve(configFilePath))
	if err != nil {
		log.Fatal("Error reading secrets file: " + err.Error())
		return
	}
	err = json.Unmarshal(contents, &allSecrets)
	if err != nil {
		log.Fatal("Error parsing secrets file: " + err.Error())
		return
	}
}

// GetSecret fetches a secret from the allSecret global map and returns an error if not found.
func GetSecret(secretKey string) (string, error) {
	if len(allSecrets) == 0 {
		fetchSecrets()
	}

	val, present := allSecrets[secretKey]
	if !present {
		return "", errors.New("Secret " + secretKey + " not found.")
	}
	return val, nil
}
