package warnings

// Warning is a notification that contains a message that should be delivered to an end user as auxiliary information.
type Warning interface {
	Message() string
}

// InvalidEmailAddressWarning is returned when attempting to send an email to an invalid email address.
type InvalidEmailAddressWarning struct {
}

// Message returns the string representation of an InvalidEmailAddressWarning.
func (e InvalidEmailAddressWarning) Message() string {
	return "Email was not sent because user does not have a valid email address."
}

// DeletedUserWarning is returned when attempting to send an email to a deleted user.
type DeletedUserWarning struct {
}

// Message returns the string representation of a DeletedUserWarning.
func (e DeletedUserWarning) Message() string {
	return "Email was not sent because user has been deleted."
}

// TOSWarning is returned when attempting to send an email to a user that violated TOS.
type TOSWarning struct {
}

// Message returns the string representation of a TOSWarning.
func (e TOSWarning) Message() string {
	return "Email was not sent because user has violated the terms of service."
}

// UnverifiedEmailWarning is returned when attempting to send an email to an unverified user.
type UnverifiedEmailWarning struct {
}

// Message returns the string representation of an UnverifiedEmailWarning.
func (e UnverifiedEmailWarning) Message() string {
	return "Email was not sent because user has not verified their email."
}
