# aperture

[![Build Status](https://jenkins.internal.justin.tv/buildStatus/icon?job=businessviewcount-aperture-build)](https://jenkins.internal.justin.tv/job/businessviewcount-aperture-build/)

Aperture provides viewcounts for live channels. It applies a ratio to filter out secondary squad streaming viewership to normalize channel concurrents data.

[Runbook](/docs/runbook.md) | [SLA](/docs/sla.md) | [Deploying](/docs/deployment.md) | [API](docs/api.md) | [Disaster Recovery](docs/disaster_recovery.md) | [Dashboard](https://grafana.internal.justin.tv/d/K0W6FxXiz/business-view-count-aperture)

The [docs](/docs/) folder has more information about the design and internals of aperture.

## Table of Contents
1. [Service Links](#service-links)
2. [Usage](#usage)
3. [Contributing](#contributing)
    1. [Dependencies](#dependencies)
    2. [Setup](#setup)
    3. [Testing](#testing)
    4. [Vendoring](#vendoring)
4. [Project Organization](#project-organization)

## Service Links

* AWS Accounts
  * Production/Staging (twitch-cb-aws): [Console](https://twitch-cb-aws.signin.aws.amazon.com/console)
* Service Endpoints
  * Production: http://prod.aperture.cb.twitch.a2z.com
  * Staging: http://staging.aperture.cb.twitch.a2z.com

## Usage

Aperture is a [twirp](https://twitchtv.github.io/twirp/) generated service. Example client usage:
```go
import (
    "context"
    "http"

    "code.justin.tv/businessviewcount/aperture/rpc/aperture"
)

client := aperture.NewApertureProtobufClient("http://localhost:8000", http.DefaultClient)
request := &aperture.GetViewcountForAllChannelsReq{}
resp, err := client.GetViewcountForAllChannels(context.Background(), req)
...
```

Additional API documentation can be found [here](/docs/api.md).

## Contributing

Documentation of internals can be found [here](/docs/design.md).

### Dependencies

Aperture relies on some common libraries:

`mockery`: for generating unit test mocks

`protoc`: for generating protobuf/twirp services

`golangci-lint`: linting code

`dep`: golang dependency management

`clang-format`: for formatting `.proto` files

These dependencies are available using `go get` or `brew install`. If you have homebrew, you can run `make setup` to install all dependencies.

### Setup
Ensure you have homebrew installed, and then run the following commands:

```bash
make setup
make gen
```

`make run` will start the aperture server on your local machine.  Other useful tasks can be found in the Makefile.

### Testing
`make test` will run all server/core unit tests. If you update a client interface, you can run `make mocks` to update the mocks used by the unit tests.

`make ratio_lambda_test` runs unit tests for the minute watched stream processing lambda.

### Vendoring
`dep` is used to manage dependencies. To update or add a dependency, update the `Gopkg.toml` file and run `make update`.
