package config

import (
	"strings"

	"code.justin.tv/businessviewcount/aperture/internal/clients/secrets"
	"github.com/heroku/rollrus"

	log "github.com/sirupsen/logrus"
)

// SetupRollbarLogging configures an application to send logs to rollbar, for non-dev environments
func SetupRollbarLogging(secretManager *secrets.Manager, secretName, tokenKey, env string) {
	if strings.Contains(env, "dev") {
		log.Info("aperture: development logs are not sent to rollbar")
		return
	}

	rollbarToken, err := secretManager.GetSecret(secretName, tokenKey)
	if err != nil {
		log.Fatal("aperture: could not retrieve rollbar token: ", err)
	}

	rollbarLevels := []log.Level{
		log.ErrorLevel,
		log.FatalLevel,
		log.PanicLevel,
		log.WarnLevel,
	}

	rollrus.SetupLoggingForLevels(rollbarToken, env, rollbarLevels)
	log.Info("aperture: logs set to send to Rollbar")
}

type configLogger struct{}

func (l *configLogger) Log(args ...interface{}) {
	log.Warn("aperture: config error", args)
}
