# Aperture API

The aperture API is generated by twirp. You can find the service definition [here](https://git.xarth.tv/businessviewcount/aperture/blob/master/rpc/aperture/service.proto).

## Table of Contents
1. [GetViewcountForChannel](#getviewcountforchannel)
2. [GetViewcountForAll](#getviewcountforall)
3. [UpdateSpadeViewcount](#updatespadeviewcount)
4. [UpdatePubsubViewcount](#updatepubsubviewcount)

## GetViewcountForChannel
Returns viewcounts for a single channel.

Route: `/twirp/code.justin.tv.businessviewcount.aperture.Aperture/GetViewcountForChannel`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | `channelID: <string>`

Response:
```
message GetViewcountForChannelResp {
    Viewcount views = 1;
}

message Viewcount {
    uint64 count = 1;
    uint64 count_unfiltered = 2;
}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | `{ "channelID": "<string>" }`

Response:
```
{
    "views": {
        "count": "<uint64>",
        "count_unfiltered": "<uint64>"
    }
}
```


## GetViewcountForAll
Returns viewcounts for all live channels, in a map from channel id to viewcount object.

Route: `/twirp/code.justin.tv.businessviewcount.aperture.Aperture/GetViewcountForAll`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | N/A

Response:
```
message GetViewcountForAllChannelsResp {
    map<string, Viewcount> views = 1;
}

message Viewcount {
    uint64 count = 1;
    uint64 count_unfiltered = 2;
}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | N/A

Response:
```
{
    "views": {
        "<channel_id>": {
            "count": "<uint64>",
            "count_unfiltered": "<uint64>"
        },
        "<channel_id>": {
            "count": "<uint64>",
            "count_unfiltered": "<uint64>"
        },
        ...
    }
}
```

## UpdateSpadeViewcount
Writes viewcounts for all live channels to `channel_concurrents` table. This route does not return any data.

Route: `/twirp/code.justin.tv.businessviewcount.aperture.Aperture/UpdateSpadeViewcount`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | N/A

Response:
```
message UpdateSpadeViewcountResp {}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | N/A

Response:
```
{}
```

## UpdatePubsubViewcount
Publishes viewcounts for all live channels to pubsub topics. This route does not return any data.

Route: `/twirp/code.justin.tv.businessviewcount.aperture.Aperture/UpdatePubsubViewcount`

### Protobuf
Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/protobuf` | N/A

Response:
```
message UpdatePubsubViewcountResp {}
```

### JSON

Method | Headers | Body |
-------|---------|------|
POST   | `content-type: application/json` | N/A

Response:
```
{}
```
