# Deployment

Deploying aperture is done through jenkins and [clean-deploy](https://clean-deploy.internal.justin.tv/#/businessviewcount/aperture).

1. Create a new branch for a feature in [businessviewcount/aperture](https://git.xarth.tv/businessviewcount/aperture).
2. After making your changes, you can test locally by running `make run` and calling the server at `localhost:8080`.
3. Create a pull request for your branch. Ask in the slack channel #business-view-count for a review.
4. Deploy your branch to staging using clean-deploy. Errors are logged to [Rollbar](https://rollbar.com/Twitch/Aperture/items/) if you have access. They are also posted to #cb-deploys in Slack.
5. After your PR is approved, merge your branch to master and deploy, again using clean-deploy. Check Rollbar for errors.

## Jenkins Setup

The Aperture build and deploy job is split into several parts, in order to deploy lambdas and the API in separate jobs. You can see these jobs in the [jenkins file](/jenkins.groovy). The separate build/deploy jobs are:

1. API
2. Spade logger lambda
3. Output ratio lambda
4. Pubsub sender lambda
5. Error logger lambda

As a result of this, code in lambda packages can be deployed at a different rate than the code in the API packages. Each build/deploy job will be run on every deploy (so it is not possible to
deploy to the API without running the lambda deploy job), but each may finish at different times.

## Rolling Back

You can use clean-deploy to rollback your changes if anything breaks. Click the arrow next to the master branch, and select a previous version of the application. Deploy that version to production to rollback a change.
Make sure to make a new pull request to either fix your error, or revert the change. During this time, it's probably a good idea to freeze Aperture from any deployments to make sure your broken change is not re-deployed. You can freeze the project from clean-deploy by clicking the `freeze aperture` button in the top right corner.
