# Disaster Recovery

## Data Recovery

Aperture's data are stored in an ElastiCache Memcached cluster. The data include: 

- Ratios to be applied to viewcounts
- Freeze to be applied to viewcounts 

All data are all ephemeral, lasting for no more than 10 minutes. In the case of a disaster, we do not need to recover the data. 

## ElastiCache Recovery Process

The basic steps in the recovery process include:
1. Open AWS Console and make sure you are in Oregon (us-west-2) region. 
2. Navigate to ElastiCache -> Redis. 
3. Click the cluster name `cb-aperture-<env>` you want to recover from. 
4. Select any nodes whose status is not available.
5. Click Actions and select Reboot Node. 
6. If all the nodes are not available, go back to ElastiCache -> Redis, choose the cluster name to be recovered. 
Click Actions and select Reboot to reboot the entire cluster. 

## Kinesis Analytics Recovery

From https://docs.aws.amazon.com/kinesisanalytics/latest/dev/disaster-recovery-resiliency.html: 

> Kinesis Data Analytics runs in a serverless mode, and takes care of host degradations, Availability Zone availability, and other infrastructure related issues by performing automatic migration. When this happens, Kinesis Data Analytics ensures that the application is processed without any loss of data. 
