package apertureredis

import (
	"encoding/json"
	"os"
	"reflect"
	"time"

	"code.justin.tv/businessviewcount/aperture/internal/util"
	"github.com/sirupsen/logrus"
)

func parseFreeze(raw []byte) (*util.ChannelFreeze, error) {
	var freeze util.ChannelFreeze
	if err := json.Unmarshal(raw, &freeze); err != nil {
		return nil, err
	}
	return &freeze, nil
}

func logFreeze(msg, channelID string, freezeProps *util.ChannelFreeze) {
	logrus.WithFields(logrus.Fields{
		"channel_id":  channelID,
		"vc0":         freezeProps.ViewcountAtCreation,
		"length":      freezeProps.PbyPSessionLength,
		"expiration":  freezeProps.Expiration,
		"ramp_length": freezeProps.RampDownLength,
		"created_at":  freezeProps.CreatedAt,
	}).Info(msg)
}

func logFrozenChannels(freezes map[string]*util.ChannelFreeze, timestamp time.Time, msg string) {
	logrus.WithFields(logrus.Fields{
		"host_id":     os.Getenv("HOST-ID"),
		"last_update": timestamp.Unix(),
		"channel_ids": reflect.ValueOf(freezes).MapKeys(),
	}).Info(msg)
}
