package apertureredis

const getFreezesScript = `
local freeze_expiration_set_key = KEYS[1]
local freezes_key = KEYS[2]
local now = tonumber(ARGV[1])

-- Get expired channel_ids
local expired_channel_ids = redis.call('ZRANGEBYSCORE', freeze_expiration_set_key, '-inf', now)

-- loop through expired channel_ids and delete them
for i=1, #expired_channel_ids, 1 do
  local expired_channel_id = expired_channel_ids[i]
  redis.call("HDEL", freezes_key, expired_channel_id)
end

-- Remove expired channel_ids
redis.call('ZREMRANGEBYSCORE', freeze_expiration_set_key, '-inf', now)

-- Return out HGetAll
return redis.call("HGETALL", freezes_key)
`
