package spade

// ViewcountEvents holds channel concurrents and global concurrents to be sent to spade
type ViewcountEvents struct {
	ChannelConcurrents []ChannelConcurrentProperties
	GlobalConcurrents  map[string]uint64
}

// ChannelConcurrentProperties represents the properties to send to spade
type ChannelConcurrentProperties struct {
	Channel           string `json:"channel"`
	ChannelID         int64  `json:"channel_id"`
	ContentID         string `json:"content_id"`
	ContentMode       string `json:"content_mode"`
	CustomerID        string `json:"customer_id"`
	DistinctID        string `json:"distinct_id"`
	EdgeManifestCount uint64 `json:"edge_manifest_count"`
	Time              int64  `json:"time"`
	Token             string `json:"token"`
	Total             uint64 `json:"total"`
}
