package stats

import (
	"time"

	"github.com/cactus/go-statsd-client/statsd"
)

// NoopClient is the statsd client that does nothing
type NoopClient struct {
	statsd.NoopClient
}

// NewNoopClient creates a new statsd that does nothing
func NewNoopClient() *NoopClient {
	return &NoopClient{
		NoopClient: statsd.NoopClient{},
	}
}

// ExecutionTime does nothing. Yay
func (c *NoopClient) ExecutionTime(statName string, duration time.Duration) {}

// SendGauge does nothing.
func (c *NoopClient) SendGauge(statName string, value int64) {}

// SendFGauge does nothing.
func (c *NoopClient) SendFGauge(statName string, value float64) {}
