package fetcher

import (
	"context"
	"strconv"
	"time"

	"code.justin.tv/businessviewcount/aperture/internal/clients/frozone"
	viewcount "code.justin.tv/video/viewcount-api/lib/client"
	redis "github.com/go-redis/redis/v7"
)

func getChannelIDs(views map[uint64]*viewcount.Viewcount) []string {
	channelIDs := make([]string, 0, len(views))
	for channelID, view := range views {
		if view.Count == 0 {
			continue
		}
		channelIDs = append(channelIDs, strconv.FormatUint(channelID, 10))
	}
	return channelIDs
}

func (c *Client) applyFreezeToChannel(ctx context.Context, channelID string, viewcountWithRatio uint64) (uint64, error) {
	freeze, err := c.RedisClient.GetFrozenChannel(ctx, channelID)
	if err != nil && err != redis.Nil {
		return viewcountWithRatio, err
	}

	return frozone.CalculateViewCount(time.Now(), viewcountWithRatio, freeze), nil
}
