package kinesisanalytics

// Event represents the input event from Amazon Kinesis Analytics. It is used as the input parameter.
type Event struct {
	InvocationID   string        `json:"invocationId"`
	ApplicationARN string        `json:"applicationArn"`
	Records        []EventRecord `json:"records"`
}

// EventRecord represents an input record from Amazon Kinesis Analytics.
type EventRecord struct {
	RecordID                     string                       `json:"recordId"`
	LambdaDeliveryRecordMetadata LambdaDeliveryRecordMetadata `json:"lambdaDeliveryRecordMetadata"`
	Data                         []byte                       `json:"data"`
}

// LambdaDeliveryRecordMetadata represents the metadata for lambda delivery from Amazon Kinesis Analytics.
type LambdaDeliveryRecordMetadata struct {
	RetryHint int `json:"retryHint"`
}

// Constants used for describing the delivery result.
const (
	DeliveryStateOk               = "Ok"
	DeliveryStateProcessingFailed = "ProcessingFailed"
)

// Response represents the output response from Lambda to Amazon Kinesis Analytics.
type Response struct {
	Records []ResponseRecord `json:"records"`
}

// ResponseRecord represents an output record from Lambda to Amazon Kinesis Analytics.
type ResponseRecord struct {
	RecordID string `json:"recordId"`
	Result   string `json:"result"` // The status of the delivery. May be DeliveryStateOk or DeliveryStateProcessingFailed
}
