package util

import (
	"net/http"

	log "github.com/sirupsen/logrus"
)

// HealthCheck is for internal monitoring of the server's health.
func HealthCheck(w http.ResponseWriter, r *http.Request) {
	w.Header().Add("Cache-Control", "no-cache, no-store, must-revalidate")
	w.Header().Add("Content-Type", "text/plain; charset=utf-8")

	w.WriteHeader(http.StatusOK)

	_, err := w.Write([]byte("Health check OK"))
	if err != nil {
		log.WithError(err).Error("[HEALTH CHECK] Failed to respond to automatic health check")
	}
}
