package util

import (
	"net/http"

	log "github.com/sirupsen/logrus"
)

// PanicRecovery is an HTTP middleware that recovers from a panic
// and logs the error. This is used so that we can send alerts from
// rollbar upon the first instance of a panic. We defer to http.Server
// and twirp to actually handle the request response during a panic.
func PanicRecovery(inner http.Handler) http.Handler {
	middleware := func(w http.ResponseWriter, r *http.Request) {
		defer func() {
			if err := recover(); err != nil {
				log.Errorf("[PANIC RECOVERY] %+v", err)
			}
		}()

		inner.ServeHTTP(w, r)
	}

	return http.HandlerFunc(middleware)
}
