multiJob('businessviewcount-aperture-build') {
  concurrentBuild()

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  triggers {
    githubPush {
      githubPolling(false)
    }
  }

  configure { project ->
    project / builders / 'com.cloudbees.jenkins.GitHubSetCommitStatusBuilder'
  }

  publishers {
    githubCommitNotifier()
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    phase('Build') {
      phaseJob('businessviewcount-aperture-api-build') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('businessviewcount-aperture-ratio-lambda-build') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('businessviewcount-aperture-spade-logger-lambda-build') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('businessviewcount-aperture-pubsub-sender-lambda-build') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }

      phaseJob('businessviewcount-aperture-error-stream-logger-lambda-build') {
        killPhaseCondition('FAILURE')
        parameters {
          gitRevision()
          predefinedProp('GIT_COMMIT', '$GIT_COMMIT')
        }
      }
    }
  }
}

freeStyleJob('businessviewcount-aperture-api-build') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_api.sh'
  }
}

freeStyleJob('businessviewcount-aperture-ratio-lambda-build') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_ratio_lambda.sh'
  }
}

freeStyleJob('businessviewcount-aperture-spade-logger-lambda-build') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_spade_logger_lambda.sh'
  }
}

freeStyleJob('businessviewcount-aperture-pubsub-sender-lambda-build') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_pubsub_sender_lambda.sh'
  }
}

freeStyleJob('businessviewcount-aperture-error-stream-logger-lambda-build') {
  parameters {
    stringParam 'GIT_COMMIT'
  }

  concurrentBuild true

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      clean true
    }
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    sshAgent 'git-aws-read-key'
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
    }
    buildName('#\${BUILD_NUMBER} (\${GIT_BRANCH})')
  }

  steps {
    shell './scripts/build_error_stream_logger_lambda.sh'
  }
}

multiJob('businessviewcount-aperture-deploy') {
  parameters {
    stringParam 'ENVIRONMENT'
    stringParam 'BRANCH'
    stringParam 'GIT_COMMIT'
  }

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    buildName('#\${BUILD_NUMBER} - \${ENVIRONMENT}')
  }

  steps {
    phase('Deploy') {
      phaseJob('businessviewcount-aperture-api-deploy') {
        killPhaseCondition('FAILURE')
      }

      phaseJob('businessviewcount-aperture-ratio-lambda-deploy') {
        killPhaseCondition('FAILURE')
      }

      phaseJob('businessviewcount-aperture-spade-logger-lambda-deploy') {
        killPhaseCondition('FAILURE')
      }

      phaseJob('businessviewcount-aperture-pubsub-sender-lambda-deploy') {
        killPhaseCondition('FAILURE')
      }

      phaseJob('businessviewcount-aperture-error-stream-logger-lambda-deploy') {
        killPhaseCondition('FAILURE')
      }
    }
  }
}

freeStyleJob('businessviewcount-aperture-api-deploy') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/deploy_api.sh'
  }
}

freeStyleJob('businessviewcount-aperture-ratio-lambda-deploy') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/build_ratio_lambda.sh'
    shell './scripts/deploy_ratio_lambda.sh'
  }
}

freeStyleJob('businessviewcount-aperture-spade-logger-lambda-deploy') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/build_spade_logger_lambda.sh'
    shell './scripts/deploy_spade_logger_lambda.sh'
  }
}

freeStyleJob('businessviewcount-aperture-pubsub-sender-lambda-deploy') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/build_pubsub_sender_lambda.sh'
    shell './scripts/deploy_pubsub_sender_lambda.sh'
  }
}

freeStyleJob('businessviewcount-aperture-error-stream-logger-lambda-deploy') {
  using 'TEMPLATE-minimal-skadi-deploy'

  wrappers {
    logRotator {
      daysToKeep(14)
    }
    preBuildCleanup()
    timestamps()
    colorizeOutput()
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'twitch-cb-aws_devtools-jenkins_aws-config')
      file('AWS_SHARED_CREDENTIALS_FILE', 'twitch-cb-aws_devtools-jenkins_aws-credentials-file')
    }
    buildName('#\${BUILD_NUMBER} - (\${BRANCH}) - \${ENVIRONMENT}')
  }

  scm {
    git {
      remote {
        github 'businessviewcount/aperture', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
      branches '${GIT_COMMIT}'
      clean true
    }
  }

  steps {
    shell './scripts/build_error_stream_logger_lambda.sh'
    shell './scripts/deploy_error_stream_logger_lambda.sh'
  }
}
