-- Input parallelism: 8

-- Create a stream of total minute-watched for non-squad-stream-secondary player and all the players for the past minute
-- per input parallelism 
CREATE OR REPLACE STREAM "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM" (
  "channel_id"     VARCHAR(32),
  "total"          INTEGER,
  "filtered_count" INTEGER,
  "window_time"    TIMESTAMP
);

-- Create 8 pumps as our input parallelism is 8
CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_001" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_001".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_001"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_001".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_002" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_002".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_002"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_002".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_003" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_003".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_003"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_003".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_004" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_004".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_004"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_004".ROWTIME BY INTERVAL '60' SECOND);


CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_005" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_005".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_005"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_005".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_006" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_006".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_006"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_006".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_007" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_007".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_007"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_007".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_008" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_008".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_008"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_008".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_009" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_009".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_009"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_009".ROWTIME BY INTERVAL '60' SECOND);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_010" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_010".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_010"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_010".ROWTIME BY INTERVAL '60' SECOND);


CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_011" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_011".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_011"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_011".ROWTIME BY INTERVAL '60' SECOND);


CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_012" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_012".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_012"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_012".ROWTIME BY INTERVAL '60' SECOND);


CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_013" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_013".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_013"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_013".ROWTIME BY INTERVAL '60' SECOND);


CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_014" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_014".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_014"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_014".ROWTIME BY INTERVAL '60' SECOND);


CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_015" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_015".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_015"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_015".ROWTIME BY INTERVAL '60' SECOND);


CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM_PUMP_016" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
SELECT STREAM
  "channel_id",
  COUNT("player") AS "total",
  COUNT(CASE WHEN "player" <> 'squad_secondary' AND "player" <> 'multiview-secondary' THEN 1 ELSE NULL END) AS "filtered_count",
  STEP("MINUTE_WATCHED_STREAM_016".ROWTIME BY INTERVAL '60' SECOND) AS "window_time"
FROM "MINUTE_WATCHED_STREAM_016"
GROUP BY "channel_id", STEP("MINUTE_WATCHED_STREAM_016".ROWTIME BY INTERVAL '60' SECOND);


-- Create a stream of total minute-watched for non-squad-stream-secondary player and all the players 
-- for the past minute, aggregating across input parallelisms
CREATE OR REPLACE STREAM "ONE_MINUTE_ROLLING_WINDOW_AGG_MW_STREAM" (
  "channel_id"     VARCHAR(32),
  "total"          INTEGER,
  "filtered_count" INTEGER,
  "window_time"    TIMESTAMP,
  "agg_count"      INTEGER
);

CREATE OR REPLACE PUMP "ONE_MINUTE_ROLLING_WINDOW_AGG_MW_STREAM_PUMP" AS
INSERT INTO "ONE_MINUTE_ROLLING_WINDOW_AGG_MW_STREAM"
SELECT STREAM
  "channel_id",
  SUM("total") AS "total",
  SUM("filtered_count") AS "filtered_count",
  STEP("ONE_MINUTE_ROLLING_WINDOW_MW_STREAM".ROWTIME BY INTERVAL '60' SECOND) AS "window_time",
  COUNT(*) AS "agg_count"
FROM "ONE_MINUTE_ROLLING_WINDOW_MW_STREAM"
GROUP BY "channel_id", STEP("ONE_MINUTE_ROLLING_WINDOW_MW_STREAM".ROWTIME BY INTERVAL '60' SECOND);

-- Create a stream of ratio of filtered player over all the players by summing up the non-squad-stream-secondary
-- players/total players in the past 5 minutes (may include up to 6 minutes) and taking the ratio
CREATE OR REPLACE STREAM "FIVE_MINUTE_MW_RATIO_STREAM" (
  "channel_id"      VARCHAR(32),
  "minutes"         INTEGER,
  "ratio"           DOUBLE,
  "total"           INTEGER,
  "filtered_count"  INTEGER,
  "window_end_time" TIMESTAMP
);

CREATE OR REPLACE PUMP "FIVE_MINUTE_MW_RATIO_STREAM_PUMP" AS
INSERT INTO "FIVE_MINUTE_MW_RATIO_STREAM"
SELECT STREAM
  "channel_id",
  COUNT(*) OVER FIVE_MINUTE_SLIDING_WINDOW AS "minutes",
  (SUM("filtered_count") OVER FIVE_MINUTE_SLIDING_WINDOW)/(CAST((SUM("total") OVER FIVE_MINUTE_SLIDING_WINDOW) AS DOUBLE)) AS "ratio",
  SUM("total") OVER FIVE_MINUTE_SLIDING_WINDOW AS "total",
  SUM("filtered_count") OVER FIVE_MINUTE_SLIDING_WINDOW AS "filtered_count",
  MAX("window_time") OVER FIVE_MINUTE_SLIDING_WINDOW AS "window_end_time"
FROM "ONE_MINUTE_ROLLING_WINDOW_AGG_MW_STREAM"
WINDOW FIVE_MINUTE_SLIDING_WINDOW AS (
  PARTITION BY "channel_id"
  RANGE INTERVAL '5' MINUTE PRECEDING
);
