#!/bin/bash
set -e

rm -rf deploy
mkdir -p deploy

echo "AWS_CONFIG_FILE: $AWS_CONFIG_FILE"
if [ -f "$AWS_CONFIG_FILE" ];
then
   echo "AWS_CONFIG_FILE exists"
else
   echo "AWS_CONFIG_FILE does not exist"
fi

cp -R .ebextensions/ deploy/.ebextensions
cd deploy

cat <<EOF > Dockerrun.aws.json
{
  "AWSEBDockerrunVersion": "1",
  "Image": {
    "Name": "docker.pkgs.xarth.tv/businessviewcount/aperture:$GIT_COMMIT",
    "Update": "false"
  },
  "Ports": [
    {
      "ContainerPort": "8000"
    }
  ],
  "Volumes": [
    {
      "ContainerDirectory": "/var/app",
      "HostDirectory": "/var/app"
    }
  ],
  "Logging": "/var/log/"
}
EOF

mkdir -p .elasticbeanstalk

cat <<EOF > .elasticbeanstalk/config.yml
global:
  application_name: cb-aperture-$ENVIRONMENT
  default_region: us-west-2
  profile: twitch-cb-aws
EOF

echo "cb-aperture-$ENVIRONMENT-api-$GIT_COMMIT"

eb deploy cb-aperture-$ENVIRONMENT-api \
  --label $ENVIRONMENT-api-$GIT_COMMIT \
  --message "$BRANCH" \
  --timeout 25 \
  --verbose

echo "businessviewcount.aperture.$ENVIRONMENT.deploy:1|c" | nc -w 1 -u graphite.internal.justin.tv 8125
