variable "asg_max_size" {
  type        = string
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = string
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_account_id" {
  type        = string
  description = "AWS account id"
}

variable "aws_key_name" {
  type = string
}

variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "instance_size" {
  type        = string
  description = "Size of the EC2 instances in the environment"
}

variable "name" {
  type        = string
  default     = "aperture"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "businessviewcount/aperture"
  description = "GitHub repository name"
}

variable "sandstorm_iam_role_arn" {
  type        = string
  description = "ARN of the sandstorm IAM role used to access secrets"
}

variable "solution_stack_name" {
  type        = string
  default     = "64bit Amazon Linux 2018.03 v2.16.5 running Docker 19.03.13-ce"
  description = "Application stack specification"
}

variable "team" {
  type        = string
  default     = "Creator Experience"
  description = "Twitch team name"
}

variable "vpc_id" {
  type        = string
  description = "Twitch businessviewcount vpc"
}

variable "private_subnets" {
  type        = list(string)
  description = "Twitch businessviewcount private subnets"
}

variable "security_group" {
  type        = string
  description = "Twitch businessviewcount security group"
}

variable "allow_assume_role_arn" {
  type        = string
  description = "AWS IAM Role ARN to allow to assume the application's role.  Used to allow jenkins to assume the development role so as to run integration tests"
  default     = ""
}
