# Alarms when the average cpu utilization of the instances in the ASG crosses 80% for 20 minutes
resource "aws_cloudwatch_metric_alarm" "app_asg_cpu" {
  alarm_name          = "${var.elastic_beanstalk_environment_name}-asg-cpu"
  alarm_description   = "Monitors the average cpu utilization of ${var.name} Elastic Beanstalk autoscaling group"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "CPUUtilization"
  namespace           = "AWS/EC2"
  period              = 60
  statistic           = "Average"
  threshold           = 80

  dimensions = {
    AutoScalingGroupName = var.elastic_beanstalk_asg_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
