# Alarms when the health of the environment goes into degraded or severe
resource "aws_cloudwatch_metric_alarm" "app_beanstalk_environment_health" {
  alarm_name          = "${var.elastic_beanstalk_environment_name}-health"
  alarm_description   = "Monitors the health of ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "EnvironmentHealth"
  namespace           = "AWS/ElasticBeanstalk"
  period              = 60
  statistic           = "Maximum"
  threshold           = 20                                                         # Degraded

  dimensions = {
    EnvironmentName = var.elastic_beanstalk_environment_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the average P90 latency of the environment crosses 500ms for 20 minutes
resource "aws_cloudwatch_metric_alarm" "app_beanstalk_avg_latency" {
  alarm_name          = "${var.elastic_beanstalk_environment_name}-avg-latency"
  alarm_description   = "Monitors the average latency of ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "ApplicationLatencyP90"
  namespace           = "AWS/ElasticBeanstalk"
  period              = 60
  statistic           = "Average"
  threshold           = 500

  dimensions = {
    EnvironmentName = var.elastic_beanstalk_environment_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
