resource "aws_cloudwatch_metric_alarm" "cache_evictions" {
  alarm_name = "${var.elasticache_cluster_id}-cache-evictions"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Evictions"
  namespace           = "AWS/ElastiCache"
  period              = 60
  statistic           = "Sum"
  threshold           = 100

  dimensions = {
    CacheClusterId = var.elasticache_cluster_id
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

module "cluster_alarms_1" {
  source             = "../elasticache_alarms"
  cluster_id_prefix  = "${var.aperture_redis_cluster_id}-0001"
  num_cache_clusters = "4" // var.elasticache_redis_num_nodes + 1
  node_type          = "cache.r4.xlarge"
  action_arns = [
    "${aws_sns_topic.vax_alarm.arn}",
    "${aws_sns_topic.pagerduty_sns_topic.arn}"
  ]

  curr_connections_threshold = var.curr_connections_threshold
}
