# Alarms when the amount of 5XX backend errors reaches 500 for 5 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_backend_5XX" {
  alarm_name          = "${var.elastic_beanstalk_environment_name}-backend-5XX"
  alarm_description   = "Monitors the number of backend 5XX responses from ${var.name} Elastic Beanstalk API"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 5
  metric_name         = "HTTPCode_Backend_5XX"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Sum"
  threshold           = 500

  dimensions = {
    LoadBalancerName = var.elastic_beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the amount of spillover from the surge queue reaches 2500 for 2 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_spillover" {
  alarm_name          = "${var.elastic_beanstalk_environment_name}-spillover"
  alarm_description   = "Monitors the number of requests spilled from the surge queue from ${var.name} Elastic Beanstalk load balancer"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Spillover"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Sum"
  threshold           = 2500

  dimensions = {
    LoadBalancerName = var.elastic_beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the amount of 5XX errors returned from the ELB reaches 500 for 5 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_5XX" {
  alarm_name          = "${var.elastic_beanstalk_environment_name}-elb-5xx"
  alarm_description   = "Monitors the number of 5XX responses from ${var.name} Elastic Beanstalk load balancer"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "HTTPCode_ELB_5XX"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Sum"
  threshold           = 500

  dimensions = {
    LoadBalancerName = var.elastic_beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

# Alarms when the latency of the ELB to instances is greater than 500ms for 20 minutes
resource "aws_cloudwatch_metric_alarm" "app_elb_latency" {
  alarm_name          = "${var.elastic_beanstalk_environment_name}-elb-latency"
  alarm_description   = "Monitors the latency from ${var.name} Elastic Beanstalk load balancer"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 20
  metric_name         = "Latency"
  namespace           = "AWS/ELB"
  period              = 60
  statistic           = "Average"
  threshold           = 500

  dimensions = {
    LoadBalancerName = var.elastic_beanstalk_loadbalancer_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
