resource "aws_cloudwatch_metric_alarm" "kinesis_analytics_lambda_delivery_failed_records" {
  alarm_name = "${var.kinesis_analytics_app_name}-lambda-delivery-failed-records"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "LambdaDelivery.DeliveryFailedRecords"
  namespace           = "AWS/KinesisAnalytics"
  period              = 60
  statistic           = "Sum"
  threshold           = 100

  dimensions = {
    Application = var.kinesis_analytics_app_name
    Flow        = "Output"
    Id          = "1.1"
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "kinesis_analytics_millis_behind" {
  alarm_name = "${var.kinesis_analytics_app_name}-millis-behind"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "MillisBehindLatest"
  namespace           = "AWS/KinesisAnalytics"
  period              = 60
  statistic           = "Average"
  threshold           = 60000

  dimensions = {
    Application = var.kinesis_analytics_app_name
    Flow        = "Input"
    Id          = "1.1"
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
