resource "aws_cloudwatch_metric_alarm" "kinesis_lambda_errors" {
  alarm_name = "${var.mw_ratio_lambda_name}-lambda-errors"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Sum"
  threshold           = 5

  dimensions = {
    FunctionName = var.mw_ratio_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "error_stream_logger_lambda_errors" {
  alarm_name = "${var.error_stream_logger_lambda_name}-lambda-errors"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Sum"
  threshold           = 5

  dimensions = {
    FunctionName = var.error_stream_logger_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "spade_logger_lambda_errors" {
  alarm_name = "${var.spade_logger_lambda_name}-lambda-errors"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Sum"
  threshold           = 5

  dimensions = {
    FunctionName = var.spade_logger_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "spade_logger_lambda_duration" {
  alarm_name = "${var.spade_logger_lambda_name}-lambda-duration"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Duration"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Average"
  threshold           = 30000                           # 30 seconds

  dimensions = {
    FunctionName = var.spade_logger_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "spade_logger_lambda_invocations" {
  alarm_name = "${var.spade_logger_lambda_name}-lambda-invocations"

  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Invocations"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Maximum"
  threshold           = 0

  dimensions = {
    FunctionName = var.spade_logger_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "pubsub_sender_lambda_errors" {
  alarm_name = "${var.pubsub_sender_lambda_name}-lambda-errors"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 2
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Sum"
  threshold           = 5

  dimensions = {
    FunctionName = var.pubsub_sender_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "pubsub_sender_lambda_duration" {
  alarm_name = "${var.pubsub_sender_lambda_name}-lambda-duration"

  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Duration"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Average"
  threshold           = 60000                           # 1 minute

  dimensions = {
    FunctionName = var.pubsub_sender_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}

resource "aws_cloudwatch_metric_alarm" "pubsub_sender_lambda_invocations" {
  alarm_name = "${var.pubsub_sender_lambda_name}-lambda-invocations"

  comparison_operator = "LessThanOrEqualToThreshold"
  evaluation_periods  = 10
  metric_name         = "Invocations"
  namespace           = "AWS/Lambda"
  period              = 60
  statistic           = "Maximum"
  threshold           = 0

  dimensions = {
    FunctionName = var.spade_logger_lambda_name
  }

  alarm_actions      = [aws_sns_topic.pagerduty_sns_topic.arn]
  ok_actions         = [aws_sns_topic.pagerduty_sns_topic.arn]
  treat_missing_data = "notBreaching"
}
