variable "name" {
  type        = string
  default     = "aperture"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "elastic_beanstalk_environment_name" {
  type        = string
  description = "Environment name of the elastic beanstalk application"
}

variable "elastic_beanstalk_loadbalancer_name" {
  type        = string
  description = "Load balancer name for the elastic beanstalk application"
}

variable "elastic_beanstalk_asg_name" {
  type        = string
  description = "Autoscaling group name for the elastic beanstalk application"
}

variable "elasticache_cluster_id" {
  type        = string
  description = "Elasticache cluster ID"
}

variable "kinesis_analytics_app_name" {
  type        = string
  description = "Kinesis Analytics app name"
}

variable "mw_ratio_lambda_name" {
  type        = string
  description = "output minute-watched ratio to elasticache lambda name"
}

variable "error_stream_logger_lambda_name" {
  type        = string
  description = "log error_stream from kinesis analytics lambda name"
}

variable "pagerduty_endpoint" {
  type        = string
  description = "PagerDuty endpoint to POST to when an alarm is triggered in EBS"
}

variable "pubsub_sender_lambda_name" {
  type        = string
  description = "pubsub sender lambda name"
}

variable "spade_logger_lambda_name" {
  type        = string
  description = "spade logger lambda name"
}

variable "vax_pagerduty_url" {
  type        = string
  description = "The pagerduty hook to page VAX"
}

variable curr_connections_threshold {
  type        = number
  description = "The max number of conns to redis before the alarm triggers"
}

variable aperture_redis_cluster_id {
  type        = string
  description = "The id for the aperture redis cluster"
}
