variable "name" {
  type        = string
  default     = "aperture"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "businessviewcount/aperture"
  description = "GitHub repository name"
}

variable "team" {
  type        = string
  default     = "Creator Experience"
  description = "Twitch team name"
}

variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "private_subnets" {
  type        = list(string)
  description = "Twitch businessviewcount private subnets"
}

variable "security_group" {
  type        = string
  description = "Twitch businessviewcount security group"
}

variable "elasticache_node_type" {
  type        = string
  description = "The compute and memory capacity of the cache nodes"
}

variable "elasticache_node_count" {
  type        = string
  description = "The initial number of cache nodes that the cache cluster will have"
}

variable "elasticache_redis_node_type" {
  type        = string
  description = "The compute and memory capacity of the cache nodes"
}

variable "elasticache_redis_num_nodes" {
  type        = string
  description = "The number of nodes in the redis cluster"
}
