variable "cluster_id_prefix" {
  type = string
}

variable "num_cache_clusters" {
  type = string
}

variable "node_type" {
  type = string
}

# Comma separated list of alarm actions in the form of ARNs
variable "action_arns" {
  type = list(string)
}

variable "engine_cpu_utilization_period" {
  default = 60
}

variable "engine_cpu_utilization_threshold" {
  default = 80
}

variable "engine_cpu_utilization_evaluation_periods" {
  default = 1
}

variable "evictions_period" {
  default = 60
}

variable "evictions_threshold" {
  default = 1 # any evictions means that keys have been evicted due to the maxmmemory limit.
}

variable "evictions_evaluation_periods" {
  default = 1
}

variable "curr_connections_period" {
  default = 60
}

variable "curr_connections_threshold" {
  default = 4000 # this many connections is abnormal
}

variable "curr_connections_datapoints_to_alarm" {
  default = 0
}

variable "curr_connections_evaluation_periods" {
  default = 1
}

variable "new_connections_period" {
  default = 60
}

variable "new_connections_threshold" {
  default = 4000 # this many connections is abnormal
}

variable "new_connections_evaluation_periods" {
  default = 1
}

variable "reserved_memory_percent" {
  default     = 25
  description = "The reserved-memory-percent value in the redis clusters parameter group. Most clusters in twitch-chat-aws use 25%"
}

variable "bytes_used_for_cache_period" {
  default = 60
}

variable "bytes_used_for_cache_perc_threshold" {
  default     = "80"
  description = "BytesUsedForCache usage percentage threshold. The threshold is calculated to be: 'bytes_used_for_cache_perc_threshold/100 * (maxmemory - (maxmemory * reserved_memory_percent/100))'"
}

variable "bytes_used_for_cache_evaluation_periods" {
  default = 1
}

variable "swap_usage_period" {
  default = 60
}

variable "swap_usage_threshold" {
  default     = 50
  description = "Swap usage in megabytes"
}

variable "swap_usage_evaluation_periods" {
  default = 1
}
