module "output_mw_ratio_to_elasticache_lambda" {
  source      = "../lambda/output_mw_ratio_to_elasticache"
  environment = var.environment
  aws_profile = var.aws_profile
  aws_region  = var.aws_region

  private_subnets = var.private_subnets
  security_group  = var.security_group
}

resource "aws_iam_role_policy" "minute_watched_ratio_app_lambda_policy" {
  name = "${aws_iam_role.minute_watched_ratio_app_role.name}-ratio-lambda-policy"
  role = aws_iam_role.minute_watched_ratio_app_role.id

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
            "Sid": "UseLambdaFunction",
            "Effect": "Allow",
            "Action": [
                "lambda:InvokeFunction",
                "lambda:GetFunctionConfiguration"
            ],
            "Resource": [
                "${module.output_mw_ratio_to_elasticache_lambda.lambda_function_arn}"
            ]
        }
    ]
}
EOF
}

module "error_stream_logger_lambda" {
  source      = "../lambda/error_stream_logger"
  environment = var.environment
  aws_profile = var.aws_profile
  aws_region  = var.aws_region

  private_subnets = var.private_subnets
  security_group  = var.security_group
}

resource "aws_iam_role_policy" "error_stream_logger_lambda_policy" {
  name = "${aws_iam_role.minute_watched_ratio_app_role.name}-error-lambda-policy"
  role = aws_iam_role.minute_watched_ratio_app_role.id

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
            "Sid": "UseLambdaFunction",
            "Effect": "Allow",
            "Action": [
                "lambda:InvokeFunction",
                "lambda:GetFunctionConfiguration"
            ],
            "Resource": [
                "${module.error_stream_logger_lambda.lambda_function_arn}"
            ]
        }
    ]
}
EOF
}
