variable "name" {
  type        = string
  default     = "aperture"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "businessviewcount/aperture"
  description = "GitHub repository name"
}

variable "team" {
  type        = string
  default     = "Creator Experience"
  description = "Twitch team name"
}

variable "aws_profile" {
  type        = string
  default     = "twitch-cb-aws"
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "private_subnets" {
  type        = list(string)
  description = "Twitch businessviewcount private subnets"
}

variable "security_group" {
  type        = string
  description = "Twitch businessviewcount security group"
}

variable "shard_count" {
  type        = string
  description = "Number of shards for the kinesis stream"
}

variable "stream_name" {
  type        = string
  description = "Name of the kinesis stream"
}

variable "alarm_on_low_number_of_events" {
  type        = string
  default     = "0"
  description = "Whether we alarm when the stream has less than 1% of the full capacity coming through"
}

variable "scieng_sns_topic" {
  type        = string
  default     = "arn:aws:sns:us-west-2:673385534282:spade-downstream-prod-alert"
  description = "SNS topic for Kinesis alarms for Scieng team"
}

variable "pagerduty_sns_topic" {
  type        = string
  default     = ""
  description = "SNS topic for pagerduty alarms"
}

variable "output_stream_name" {
  type        = string
  default     = "FIVE_MINUTE_MW_RATIO_STREAM"
  description = "The name of the in-application stream to be outputted by kinesis analytics application"
}
