resource "aws_iam_role" "output_mw_ratio_to_elasticache_lambda_role" {
  name = "cb-${var.name}-${var.environment}-${var.lambda_name}-role"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Principal": {
        "Service": "lambda.amazonaws.com"
      },
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_cloudwatch_log_group" "output_mw_ratio_to_elasticache_lambda_log_group" {
  name = "/aws/lambda/${var.name}-${var.environment}-${var.lambda_name}"
}

resource "aws_iam_role_policy_attachment" "lambda_policy_attach" {
  role       = aws_iam_role.output_mw_ratio_to_elasticache_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole"
}

resource "aws_iam_role_policy_attachment" "ratio_lambda_ssm_policy_attach" {
  role       = aws_iam_role.output_mw_ratio_to_elasticache_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/AmazonSSMReadOnlyAccess"
}

resource "aws_iam_role_policy" "output_mw_ratio_to_elasticache_lambda_basic_execution" {
  name = "cb-${var.name}-${var.environment}-output-mw-ratio-to-elasticache-lambda-basic-execution"
  role = aws_iam_role.output_mw_ratio_to_elasticache_lambda_role.id

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
        {
            "Effect": "Allow",
            "Action": [
                "logs:CreateLogStream",
                "logs:PutLogEvents"
            ],
            "Resource": [
                "${aws_cloudwatch_log_group.output_mw_ratio_to_elasticache_lambda_log_group.arn}"
            ]
        }
    ]
}
EOF
}

resource "aws_lambda_function" "output_mw_ratio_to_elasticache_lambda" {
  function_name = "cb-${var.name}-${var.environment}-${var.lambda_name}"
  role          = aws_iam_role.output_mw_ratio_to_elasticache_lambda_role.arn
  handler       = "main"
  runtime       = "go1.x"
  description   = "${var.team} team's lambda function to output minute-watched ratio to elasticache to be used by ${var.name} service for ${var.environment}"
  timeout       = 60
  memory_size   = 512

  vpc_config {
    subnet_ids         = var.private_subnets
    security_group_ids = [var.security_group]
  }

  environment {
    variables = {
      ENVIRONMENT = var.environment
    }
  }

  tags = {
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }

  lifecycle {
    ignore_changes = ["filename", "source_code_hash", "last_modified"]
  }
}
