variable "name" {
  type        = string
  default     = "aperture"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "team" {
  type        = string
  default     = "Creator Experience"
  description = "Twitch team name"
}

variable "aws_profile" {
  type        = string
  description = "AWS profile name"
}

variable "aws_region" {
  type        = string
  default     = "us-west-2"
  description = "AWS project region"
}

variable "environment" {
  type        = string
  description = "Service environment"
}

variable "owner" {
  type        = string
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "project" {
  type        = string
  default     = "businessviewcount/aperture"
  description = "GitHub repository name"
}

variable "lambda_name" {
  type        = string
  description = "Name of the Lambda used for AWS resourcing (application, tagging, IAM, etc.)"
  default     = "output-mw-ratio-lambda"
}

variable "private_subnets" {
  type        = list(string)
  description = "Twitch businessviewcount private subnets"
}

variable "security_group" {
  type        = string
  description = "Twitch businessviewcount security group"
}
