resource "aws_ssm_parameter" "logging_whitelist" {
  name  = "/configurations/cb/${var.environment}/${var.name}/logging.whitelist"
  type  = "StringList"
  value = "temp"

  description = "List of channel IDs to be logged to statsd in ${var.name} service for ${var.environment}"

  tags = {
    Owner   = var.owner
    Project = var.project
    Team    = var.team
  }

  lifecycle {
    ignore_changes = [
      "value",
    ]
  }
}
